#ifndef _ENTRY_CPP
#define _ENTRY_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ShlObj.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "NSWFL.H"
#include "Entry.H"
#include "Package.H"
#include "Init.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"
#include "../Dialogs/NewPassDlg.H"
#include "../Dialogs/ReadingDlg.H"
#include "../Dialogs/ExtractDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HINSTANCE ghAppInstance = NULL;

char gsAppCopyRight[64];
char gsFileVersion[32];
char gsTitleCaption[64];
char gsWorkingOutput[MAX_PATH + 1];
char gsLastExtractLocation[MAX_PATH + 1];
char gsArchiveName[MAX_PATH + 1];

DWORD gdwCurrentJobType = 0;

bool ArchiveOpen = false;

int giPkgAttribs = ATTRIB_DATETIME | ATTRIB_CRCCHECK | ATTRIB_SAVEPATHS | ATTRIB_ATTRIBUTES | ATTRIB_COMPRESSION;

short giCompressLevel = 0;
short giCryptAlgo = 0;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevious, LPSTR CmdLine, int CmdShow)
{
	ghAppInstance = hInstance;

    if(!InitializeApp())
    {
        return 1;
    }

    if(strlen(CmdLine) > 0)
    {
        strcpy(gsArchiveName, CmdLine);

        char Ext[255];
        _splitpath(CmdLine, NULL, NULL, NULL, Ext);

        if(strcmpi(Ext, ".pce") == 0)
        {
            // View an existing archive
            gdwCurrentJobType = JOB_TYPE_READING;
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_OPENPASS), NULL, OpenPassDialog) != 1)
            {
                return 0;
            }
            hWorker_Thread_Handle = CreateThread(NULL, 0, ViewExisting_Worker_Thread, (LPVOID) CmdLine, CREATE_SUSPENDED, &dwWorker_Thread_ID);
            DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }
        else if(IsDirectory(CmdLine)){
            gdwCurrentJobType = JOB_TYPE_PACKING_DIR;
            // Create a new archive from the directorys contents
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_NEWPASS), NULL, NewPassDialog) != 1)
            {
                return 0;
            }
            hWorker_Thread_Handle = CreateThread(NULL, 0, CreateNewDirArchive_Worker_Thread, (LPVOID) CmdLine, CREATE_SUSPENDED, &dwWorker_Thread_ID);
            DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }
        else{
			FilePack MyFilePack;

			MyFilePack.Initialize(&AltFilePackage);
			
			//This is alot of wasted memory, but we need it all.
			char FileName[MAX_PATH]; 
			char DirTemp[MAX_PATH]; //Just some memory for AddFile() ro use.
			char Root[MAX_PATH + 1];
			char Drive[MAX_PATH + 1];
			char Dir[MAX_PATH + 1];
			char File[MAX_PATH + 1];
			char Ext[MAX_PATH + 1];

			int RootLen = 0;

			_splitpath(CmdLine, Drive, Dir, File, Ext);
			_makepath(Root, Drive, Dir, NULL, NULL);
			_makepath(FileName, NULL, NULL, File, Ext);

			RootLen = strlen(Root);

			MyFilePack.AddFile(Root, RootLen, DirTemp, RootLen, FileName, &AltFilePackage);

			gdwCurrentJobType = JOB_TYPE_PACKING_FIL;
            // Create a new archive containing a single file.
            if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_NEWPASS), NULL, NewPassDialog) != 1)
            {
                return 0;
            }
            hWorker_Thread_Handle = CreateThread(NULL, 0, CreateFileArchive_Worker_Thread, (LPVOID) Root, CREATE_SUSPENDED, &dwWorker_Thread_ID);
            DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
        }

    }
    else{
        // Create new archive
        DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, MainDialog);
    }

    DWORD ExitCode;
    while(GetExitCodeThread(hWorker_Thread_Handle, &ExitCode))
    {
        if(ExitCode != STILL_ACTIVE)
        {
            break;
        }
        else Sleep(100);
    }

    if(!UninitializeApp())
    {
        return 1;
    }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

